/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.registrations;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.classes.InverseComparator;
import ch.njol.skript.registrations.Converters;
import ch.njol.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public class Comparators {
    public static final Collection<Comparator.ComparatorInfo<?, ?>> comparators = new ArrayList();
    private static final java.util.Comparator<Object> javaComparator = new java.util.Comparator<Object>(){

        @Override
        public int compare(@Nullable Object o1, @Nullable Object o2) {
            return Comparators.compare(o1, o2).getRelation();
        }
    };
    private static final Map<Pair<Class<?>, Class<?>>, Comparator<?, ?>> comparatorsQuickAccess = new HashMap();

    private Comparators() {
    }

    public static <T1, T2> void registerComparator(Class<T1> t1, Class<T2> t2, Comparator<T1, T2> c) {
        Skript.checkAcceptRegistrations();
        if (t1 == Object.class && t2 == Object.class) {
            throw new IllegalArgumentException("You must not add a comparator for Objects");
        }
        comparators.add(new Comparator.ComparatorInfo<T1, T2>(t1, t2, c));
    }

    public static Comparator.Relation compare(@Nullable Object o1, @Nullable Object o2) {
        if (o1 == null || o2 == null) {
            return Comparator.Relation.NOT_EQUAL;
        }
        Comparator<?, ?> c = Comparators.getComparator(o1.getClass(), o2.getClass());
        if (c == null) {
            return Comparator.Relation.NOT_EQUAL;
        }
        return c.compare(o1, o2);
    }

    public static java.util.Comparator<Object> getJavaComparator() {
        return javaComparator;
    }

    @Nullable
    public static <F, S> Comparator<? super F, ? super S> getComparator(Class<F> f, Class<S> s) {
        Pair<Class<F>, Class<S>> p = new Pair<Class<F>, Class<S>>(f, s);
        if (comparatorsQuickAccess.containsKey(p)) {
            return comparatorsQuickAccess.get(p);
        }
        Comparator<?, ?> comp = Comparators.getComparator_i(f, s);
        comparatorsQuickAccess.put(p, comp);
        return comp;
    }

    @Nullable
    private static <F, S> Comparator<?, ?> getComparator_i(Class<F> f, Class<S> s) {
        Converter<F, ?> c1;
        Converter<S, ?> c2;
        for (Comparator.ComparatorInfo<?, ?> info : comparators) {
            if (info.c1.isAssignableFrom(f) && info.c2.isAssignableFrom(s)) {
                return info.c;
            }
            if (!info.c1.isAssignableFrom(s) || !info.c2.isAssignableFrom(f)) continue;
            return new InverseComparator(info.c);
        }
        if (s == f && f != Object.class && s != Object.class) {
            return Comparator.equalsComparator;
        }
        boolean[] trueFalse = new boolean[]{true, false};
        for (Comparator.ComparatorInfo<?, ?> info : comparators) {
            for (boolean first : trueFalse) {
                if (info.getType(first).isAssignableFrom(f) && (c2 = Converters.getConverter(s, info.getType(!first))) != null) {
                    return first ? new ConvertedComparator(info.c, c2) : new InverseComparator(new ConvertedComparator(c2, info.c));
                }
                if (!info.getType(first).isAssignableFrom(s) || (c1 = Converters.getConverter(f, info.getType(!first))) == null) continue;
                return !first ? new ConvertedComparator(c1, info.c) : new InverseComparator(new ConvertedComparator(info.c, c1));
            }
        }
        for (Comparator.ComparatorInfo<?, ?> info : comparators) {
            for (boolean first : trueFalse) {
                c1 = Converters.getConverter(f, info.getType(first));
                c2 = Converters.getConverter(s, info.getType(!first));
                if (c1 == null || c2 == null) continue;
                return first ? new ConvertedComparator<F, S>(c1, info.c, c2) : new InverseComparator<F, S>(new ConvertedComparator<S, F>(c2, info.c, c1));
            }
        }
        return null;
    }

    private static final class ConvertedComparator<T1, T2>
    implements Comparator<T1, T2> {
        private final Comparator c;
        @Nullable
        private final Converter c1;
        @Nullable
        private final Converter c2;

        public ConvertedComparator(Converter<? super T1, ?> c1, Comparator<?, ?> c) {
            this.c1 = c1;
            this.c = c;
            this.c2 = null;
        }

        public ConvertedComparator(Comparator<?, ?> c, Converter<? super T2, ?> c2) {
            this.c1 = null;
            this.c = c;
            this.c2 = c2;
        }

        public ConvertedComparator(Converter<? super T1, ?> c1, Comparator<?, ?> c, Converter<? super T2, ?> c2) {
            this.c1 = c1;
            this.c = c;
            this.c2 = c2;
        }

        @Override
        public Comparator.Relation compare(T1 o1, T2 o2) {
            T2 t2;
            T1 t1;
            Converter c1 = this.c1;
            Object object = t1 = c1 == null ? o1 : c1.convert(o1);
            if (t1 == null) {
                return Comparator.Relation.NOT_EQUAL;
            }
            Converter c2 = this.c2;
            Object object2 = t2 = c2 == null ? o2 : c2.convert(o2);
            if (t2 == null) {
                return Comparator.Relation.NOT_EQUAL;
            }
            return this.c.compare(t1, t2);
        }

        @Override
        public boolean supportsOrdering() {
            return this.c.supportsOrdering();
        }

        public String toString() {
            return "ConvertedComparator(" + this.c1 + "," + this.c + "," + this.c2 + ")";
        }
    }
}

