/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.registrations;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ChainedConverter;
import ch.njol.skript.classes.Converter;
import ch.njol.util.Pair;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Converters {
    private static List<Converter.ConverterInfo<?, ?>> converters = new ArrayList(50);
    private static final Map<Pair<Class<?>, Class<?>>, Converter.ConverterInfo<?, ?>> convertersCache = new HashMap();

    private Converters() {
    }

    public static List<Converter.ConverterInfo<?, ?>> getConverters() {
        return Collections.unmodifiableList(converters);
    }

    public static <F, T> void registerConverter(Class<F> from, Class<T> to, Converter<F, T> converter) {
        Converters.registerConverter(from, to, converter, 0);
    }

    public static <F, T> void registerConverter(Class<F> from, Class<T> to, Converter<F, T> converter, int options) {
        Skript.checkAcceptRegistrations();
        Converter.ConverterInfo<F, T> info = new Converter.ConverterInfo<F, T>(from, to, converter, options);
        for (int i = 0; i < converters.size(); ++i) {
            Converter.ConverterInfo<?, ?> info2 = converters.get(i);
            if (!info2.from.isAssignableFrom(from) || !to.isAssignableFrom(info2.to)) continue;
            converters.add(i, info);
            return;
        }
        converters.add(info);
    }

    public static void createMissingConverters() {
        for (int i = 0; i < converters.size(); ++i) {
            Converter.ConverterInfo<?, ?> info = converters.get(i);
            for (int j = 0; j < converters.size(); ++j) {
                Converter.ConverterInfo<?, ?> info2 = converters.get(j);
                if ((info.options & 2) == 0 && (info2.options & 1) == 0 && info2.from.isAssignableFrom(info.to) && !Converters.converterExistsSlow(info.from, info2.to)) {
                    converters.add(Converters.createChainedConverter(info, info2));
                    continue;
                }
                if ((info.options & 1) != 0 || (info2.options & 2) != 0 || !info.from.isAssignableFrom(info2.to) || Converters.converterExistsSlow(info2.from, info.to)) continue;
                converters.add(Converters.createChainedConverter(info2, info));
            }
        }
    }

    private static boolean converterExistsSlow(Class<?> from, Class<?> to) {
        for (Converter.ConverterInfo<?, ?> i : converters) {
            if (!i.from.isAssignableFrom(from) && !from.isAssignableFrom(i.from) || !i.to.isAssignableFrom(to) && !to.isAssignableFrom(i.to)) continue;
            return true;
        }
        return false;
    }

    private static <F, M, T> Converter.ConverterInfo<F, T> createChainedConverter(Converter.ConverterInfo<?, ?> first, Converter.ConverterInfo<?, ?> second) {
        return new Converter.ConverterInfo(first, second, new ChainedConverter(first.converter, second.converter), first.options | second.options);
    }

    @Nullable
    public static <F, T> T convert(@Nullable F o, Class<T> to) {
        if (o == null) {
            return null;
        }
        if (to.isInstance(o)) {
            return (T)o;
        }
        Converter<?, T> conv = Converters.getConverter(o.getClass(), to);
        if (conv == null) {
            return null;
        }
        return conv.convert(o);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <F, T> T convert(@Nullable F o, Class<? extends T>[] to) {
        void var5_8;
        if (o == null) {
            return null;
        }
        for (Class<T> clazz : to) {
            if (!clazz.isInstance(o)) continue;
            return (T)o;
        }
        Class<?> c = o.getClass();
        Class<? extends T>[] classArray = to;
        int n = classArray.length;
        boolean bl = false;
        while (var5_8 < n) {
            Class<? extends T> t = classArray[var5_8];
            Converter<?, T> conv = Converters.getConverter(c, t);
            if (conv != null) {
                return conv.convert(o);
            }
            ++var5_8;
        }
        return null;
    }

    @Nullable
    public static <T> T[] convertArray(@Nullable Object[] o, Class<T> to) {
        assert (to != null);
        if (o == null) {
            return null;
        }
        if (to.isAssignableFrom(o.getClass().getComponentType())) {
            return o;
        }
        ArrayList<T> l = new ArrayList<T>(o.length);
        for (Object e : o) {
            T c = Converters.convert(e, to);
            if (c == null) continue;
            l.add(c);
        }
        return l.toArray((Object[])Array.newInstance(to, l.size()));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] convertArray(@Nullable Object[] o, Class<? extends T>[] to, Class<T> superType) {
        void var6_10;
        if (o == null) {
            Object[] r = (Object[])Array.newInstance(superType, 0);
            assert (r != null);
            return r;
        }
        for (Class<T> clazz : to) {
            if (!clazz.isAssignableFrom(o.getClass().getComponentType())) continue;
            return o;
        }
        ArrayList<T> l = new ArrayList<T>(o.length);
        Object[] objectArray = o;
        int n = objectArray.length;
        boolean bl = false;
        while (var6_10 < n) {
            Object e = objectArray[var6_10];
            T c = Converters.convert(e, to);
            if (c != null) {
                l.add(c);
            }
            ++var6_10;
        }
        Object[] r = l.toArray((Object[])Array.newInstance(superType, l.size()));
        assert (r != null);
        return r;
    }

    public static <T> T[] convertStrictly(Object[] original, Class<T> to) throws ClassCastException {
        Object[] end = (Object[])Array.newInstance(to, original.length);
        for (int i = 0; i < original.length; ++i) {
            T converted = Converters.convert(original[i], to);
            if (converted == null) {
                throw new ClassCastException();
            }
            end[i] = converted;
        }
        return end;
    }

    public static <T> T convertStrictly(Object original, Class<T> to) throws ClassCastException {
        T converted = Converters.convert(original, to);
        if (converted != null) {
            return converted;
        }
        throw new ClassCastException();
    }

    public static boolean converterExists(Class<?> from, Class<?> to) {
        if (to.isAssignableFrom(from) || from.isAssignableFrom(to)) {
            return true;
        }
        return Converters.getConverter(from, to) != null;
    }

    public static boolean converterExists(Class<?> from, Class<?> ... to) {
        for (Class<?> t : to) {
            assert (t != null);
            if (!Converters.converterExists(from, t)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <F, T> Converter<? super F, ? extends T> getConverter(Class<F> from, Class<T> to) {
        Converter.ConverterInfo<F, T> info = Converters.getConverterInfo(from, to);
        return info != null ? info.converter : null;
    }

    @Nullable
    public static <F, T> Converter.ConverterInfo<? super F, ? extends T> getConverterInfo(Class<F> from, Class<T> to) {
        Pair<Class<F>, Class<T>> p = new Pair<Class<F>, Class<T>>(from, to);
        if (convertersCache.containsKey(p)) {
            return convertersCache.get(p);
        }
        Converter.ConverterInfo<F, T> c = Converters.lookupConverterInfo(from, to);
        convertersCache.put(p, c);
        return c;
    }

    @Nullable
    private static <F, T> Converter.ConverterInfo<? super F, ? extends T> lookupConverterInfo(Class<F> from, Class<T> to) {
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!conv.from.isAssignableFrom(from) || !to.isAssignableFrom(conv.to)) continue;
            return conv;
        }
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (conv.from.isAssignableFrom(from) && conv.to.isAssignableFrom(to)) {
                return new Converter.ConverterInfo<F, T>(from, to, Converter.ConverterUtils.createInstanceofConverter(conv.converter, to), 0);
            }
            if (!from.isAssignableFrom(conv.from) || !to.isAssignableFrom(conv.to)) continue;
            return new Converter.ConverterInfo<F, T>(from, to, Converter.ConverterUtils.createInstanceofConverter(conv), 0);
        }
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!from.isAssignableFrom(conv.from) || !conv.to.isAssignableFrom(to)) continue;
            return new Converter.ConverterInfo<F, T>(from, to, Converter.ConverterUtils.createDoubleInstanceofConverter(conv, to), 0);
        }
        return null;
    }

    @Nullable
    private static <F, T> Converter<? super F, ? extends T> getConverter_i(Class<F> from, Class<T> to) {
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!conv.from.isAssignableFrom(from) || !to.isAssignableFrom(conv.to)) continue;
            return conv.converter;
        }
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (conv.from.isAssignableFrom(from) && conv.to.isAssignableFrom(to)) {
                return Converter.ConverterUtils.createInstanceofConverter(conv.converter, to);
            }
            if (!from.isAssignableFrom(conv.from) || !to.isAssignableFrom(conv.to)) continue;
            return Converter.ConverterUtils.createInstanceofConverter(conv);
        }
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!from.isAssignableFrom(conv.from) || !conv.to.isAssignableFrom(to)) continue;
            return Converter.ConverterUtils.createDoubleInstanceofConverter(conv, to);
        }
        return null;
    }

    public static <F, T> T[] convertUnsafe(F[] from, Class<?> to, Converter<? super F, ? extends T> conv) {
        return Converters.convert(from, to, conv);
    }

    public static <F, T> T[] convert(F[] from, Class<T> to, Converter<? super F, ? extends T> conv) {
        Object[] ts = (Object[])Array.newInstance(to, from.length);
        int j = 0;
        for (int i = 0; i < from.length; ++i) {
            Object t;
            F f = from[i];
            Object v0 = t = f == null ? null : conv.convert((F)f);
            if (t == null) continue;
            ts[j++] = t;
        }
        if (j != ts.length) {
            ts = Arrays.copyOf(ts, j);
        }
        assert (ts != null);
        return ts;
    }
}

