/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.registrations;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Getter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class EventValues {
    private static final List<EventValueInfo<?, ?>> defaultEventValues = new ArrayList(30);
    private static final List<EventValueInfo<?, ?>> futureEventValues = new ArrayList();
    private static final List<EventValueInfo<?, ?>> pastEventValues = new ArrayList();
    public static final int TIME_PAST = -1;
    public static final int TIME_NOW = 0;
    public static final int TIME_FUTURE = 1;

    private EventValues() {
    }

    public static List<EventValueInfo<?, ?>> getEventValuesListForTime(int time) {
        return ImmutableList.copyOf(EventValues.getEventValuesList(time));
    }

    private static List<EventValueInfo<?, ?>> getEventValuesList(int time) {
        if (time == -1) {
            return pastEventValues;
        }
        if (time == 0) {
            return defaultEventValues;
        }
        if (time == 1) {
            return futureEventValues;
        }
        throw new IllegalArgumentException("time must be -1, 0, or 1");
    }

    public static <T, E extends Event> void registerEventValue(Class<E> e, Class<T> c, Getter<T, E> g, int time) {
        EventValues.registerEventValue(e, c, g, time, null, null);
    }

    @SafeVarargs
    public static <T, E extends Event> void registerEventValue(Class<E> e, Class<T> c, Getter<T, E> g, int time, @Nullable String excludeErrorMessage, Class<? extends E> ... excludes) {
        Skript.checkAcceptRegistrations();
        List<EventValueInfo<?, ?>> eventValues = EventValues.getEventValuesList(time);
        for (int i = 0; i < eventValues.size(); ++i) {
            EventValueInfo<?, ?> info = eventValues.get(i);
            if (!(info.event != e ? info.event.isAssignableFrom(e) : info.c.isAssignableFrom(c))) continue;
            eventValues.add(i, new EventValueInfo<E, T>(e, c, g, excludeErrorMessage, excludes));
            return;
        }
        eventValues.add(new EventValueInfo<E, T>(e, c, g, excludeErrorMessage, excludes));
    }

    @Nullable
    public static <T, E extends Event> T getEventValue(E e, Class<T> c, int time) {
        Getter<T, ?> getter = EventValues.getEventValueGetter(e.getClass(), c, time);
        if (getter == null) {
            return null;
        }
        return getter.get(e);
    }

    @Nullable
    public static <T, E extends Event> Getter<? extends T, ? super E> getEventValueGetter(Class<E> e, Class<T> c, int time) {
        return EventValues.getEventValueGetter(e, c, time, true);
    }

    @Nullable
    private static <T, E extends Event> Getter<? extends T, ? super E> getEventValueGetter(final Class<E> e, final Class<T> c, int time, boolean allowDefault) {
        List<EventValueInfo<?, ?>> eventValues = EventValues.getEventValuesList(time);
        for (final EventValueInfo<?, ?> ev : eventValues) {
            if (!c.equals(ev.c)) continue;
            if (!EventValues.checkExcludes(ev, e)) {
                return null;
            }
            if (!ev.event.isAssignableFrom(e)) continue;
            return ev.getter;
        }
        for (final EventValueInfo<?, ?> ev : eventValues) {
            if (!c.isAssignableFrom(ev.c)) continue;
            if (!EventValues.checkExcludes(ev, e)) {
                return null;
            }
            if (ev.event.isAssignableFrom(e)) {
                return ev.getter;
            }
            if (!e.isAssignableFrom(ev.event)) continue;
            return new Getter<T, E>(){

                @Override
                @Nullable
                public T get(E event) {
                    if (!ev.event.isInstance(event)) {
                        return null;
                    }
                    return ev.getter.get(event);
                }
            };
        }
        for (final EventValueInfo<?, ?> ev : eventValues) {
            boolean checkInstanceOf;
            if (!ev.c.isAssignableFrom(c)) continue;
            boolean bl = checkInstanceOf = !ev.event.isAssignableFrom(e);
            if (checkInstanceOf && !e.isAssignableFrom(ev.event)) continue;
            if (!EventValues.checkExcludes(ev, e)) {
                return null;
            }
            return new Getter<T, E>(){

                @Override
                @Nullable
                public T get(E event) {
                    if (checkInstanceOf && !e.isInstance(event)) {
                        return null;
                    }
                    Object object = ev.getter.get(event);
                    if (c.isInstance(object)) {
                        return object;
                    }
                    return null;
                }
            };
        }
        for (final EventValueInfo<?, ?> ev : eventValues) {
            boolean b;
            boolean bl = b = !ev.event.isAssignableFrom(e);
            if (b && !e.isAssignableFrom(ev.event)) continue;
            if (!EventValues.checkExcludes(ev, e)) {
                return null;
            }
            Getter<T, ?> getter = EventValues.getConvertedGetter(ev, c, !b);
            if (getter == null) continue;
            return getter;
        }
        if (allowDefault && time != 0) {
            return EventValues.getEventValueGetter(e, c, 0, false);
        }
        return null;
    }

    private static boolean checkExcludes(EventValueInfo<?, ?> ev, Class<? extends Event> e) {
        Class<? extends E>[] excl = ev.excludes;
        if (excl == null) {
            return true;
        }
        for (Class clazz : excl) {
            if (!clazz.isAssignableFrom(e)) continue;
            Skript.error(ev.excludeErrorMessage);
            return false;
        }
        return true;
    }

    @Nullable
    private static <E extends Event, F, T> Getter<? extends T, ? super E> getConvertedGetter(final EventValueInfo<E, F> i, Class<T> to, final boolean checkInstanceOf) {
        final Converter converter = Converters.getConverter(i.c, to);
        if (converter == null) {
            return null;
        }
        return new Getter<T, E>(){

            @Override
            @Nullable
            public T get(E e) {
                if (checkInstanceOf && !i.event.isInstance(e)) {
                    return null;
                }
                Object f = i.getter.get(e);
                if (f == null) {
                    return null;
                }
                return converter.convert(f);
            }
        };
    }

    public static boolean doesEventValueHaveTimeStates(Class<? extends Event> e, Class<?> c) {
        return EventValues.getEventValueGetter(e, c, -1, false) != null || EventValues.getEventValueGetter(e, c, 1, false) != null;
    }

    private static final class EventValueInfo<E extends Event, T> {
        public final Class<E> event;
        public final Class<T> c;
        public final Getter<T, E> getter;
        @Nullable
        public final Class<? extends E>[] excludes;
        @Nullable
        public final String excludeErrorMessage;

        public EventValueInfo(Class<E> event, Class<T> c, Getter<T, E> getter, @Nullable String excludeErrorMessage, @Nullable Class<? extends E>[] excludes) {
            assert (event != null);
            assert (c != null);
            assert (getter != null);
            this.event = event;
            this.c = c;
            this.getter = getter;
            this.excludes = excludes;
            this.excludeErrorMessage = excludeErrorMessage;
        }

        public Class<E> getEventClass() {
            return this.event;
        }

        public Class<T> getValueClass() {
            return this.c;
        }

        @Nullable
        public Class<? extends E>[] getExcludes() {
            if (this.excludes != null) {
                return Arrays.copyOf(this.excludes, this.excludes.length);
            }
            return new Class[0];
        }

        @Nullable
        public String getExcludeErrorMessage() {
            return this.excludeErrorMessage;
        }
    }
}

