/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.block.BlockCompat;
import ch.njol.skript.bukkitutil.block.BlockValues;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.Nullable;

public abstract class BlockUtils {
    public static boolean set(Block block, Material type, @Nullable BlockValues blockValues, boolean applyPhysics) {
        int flags = 13;
        if (applyPhysics) {
            flags |= 0x10;
        }
        BlockCompat.SETTER.setBlock(block, type, blockValues, flags);
        return true;
    }

    public static boolean set(Block block, ItemData type, boolean applyPhysics) {
        return BlockUtils.set(block, type.getType(), type.getBlockValues(), applyPhysics);
    }

    public static void sendBlockChange(Player player, Location location, Material type, @Nullable BlockValues blockValues) {
        BlockCompat.SETTER.sendBlockChange(player, location, type, blockValues);
    }

    public static Iterable<Block> getBlocksAround(Block b) {
        return Arrays.asList(b.getRelative(BlockFace.NORTH), b.getRelative(BlockFace.EAST), b.getRelative(BlockFace.SOUTH), b.getRelative(BlockFace.WEST));
    }

    public static Iterable<BlockFace> getFaces() {
        return Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
    }

    @Nullable
    public static Location getLocation(@Nullable Block b) {
        if (b == null) {
            return null;
        }
        Location l = b.getLocation().add(0.5, 0.5, 0.5);
        return l;
    }

    @Nullable
    public static BlockData createBlockData(String dataString) {
        String data = dataString.replace(";", ",");
        data = data.replaceAll(" (?=[^\\[]*])", "");
        data = data.replaceAll("\\s+\\[", "[");
        data = data.replace(" ", "_");
        try {
            return Bukkit.createBlockData((String)(data.startsWith("minecraft:") ? data : "minecraft:" + data));
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    @Nullable
    public static String blockToString(Block block, int flags) {
        String type = ItemType.toString(block, flags);
        Location location = BlockUtils.getLocation(block);
        if (location == null) {
            return null;
        }
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        String world = location.getWorld().getName();
        return String.format("'%s' at %s, %s, %s in world '%s'", type, x, y, z, world);
    }
}

