/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.block.BlockCompat;
import ch.njol.skript.bukkitutil.block.MagicBlockCompat;
import com.destroystokyo.paper.block.BlockSoundGroup;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class DelayedChangeBlock
implements Block {
    private static final boolean ISPASSABLE_METHOD_EXISTS = Skript.methodExists(Block.class, "isPassable", new Class[0]);
    final Block b;
    @Nullable
    private final BlockState newState;
    private final boolean isPassable;

    public DelayedChangeBlock(Block b) {
        this(b, null);
    }

    public DelayedChangeBlock(Block b, @Nullable BlockState newState) {
        assert (b != null);
        this.b = b;
        this.newState = newState;
        this.isPassable = ISPASSABLE_METHOD_EXISTS && newState != null ? newState.getBlock().isPassable() : false;
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.b.setMetadata(metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.b.getMetadata(metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.b.hasMetadata(metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.b.removeMetadata(metadataKey, owningPlugin);
    }

    public byte getData() {
        return this.b.getData();
    }

    public void setData(byte data) throws Throwable {
        MagicBlockCompat.setDataMethod.invokeExact(this.b, data);
    }

    public Block getRelative(int modX, int modY, int modZ) {
        return this.b.getRelative(modX, modY, modZ);
    }

    public Block getRelative(BlockFace face) {
        return this.b.getRelative(face);
    }

    public Block getRelative(BlockFace face, int distance) {
        return this.b.getRelative(face, distance);
    }

    public Material getType() {
        return this.b.getType();
    }

    public byte getLightLevel() {
        return this.b.getLightLevel();
    }

    public byte getLightFromSky() {
        return this.b.getLightFromSky();
    }

    public byte getLightFromBlocks() {
        return this.b.getLightFromBlocks();
    }

    public World getWorld() {
        return this.b.getWorld();
    }

    public int getX() {
        return this.b.getX();
    }

    public int getY() {
        return this.b.getY();
    }

    public int getZ() {
        return this.b.getZ();
    }

    public Location getLocation() {
        return this.b.getLocation();
    }

    public Chunk getChunk() {
        return this.b.getChunk();
    }

    public void setType(final Material type) {
        if (this.newState != null) {
            this.newState.setType(type);
        } else {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    DelayedChangeBlock.this.b.setType(type);
                }
            });
        }
    }

    @Nullable
    public BlockFace getFace(Block block) {
        return this.b.getFace(block);
    }

    public BlockState getState() {
        return this.b.getState();
    }

    public BlockState getState(boolean useSnapshot) {
        return this.b.getState(useSnapshot);
    }

    public Biome getBiome() {
        return this.b.getBiome();
    }

    public void setBiome(Biome bio) {
        this.b.setBiome(bio);
    }

    public boolean isBlockPowered() {
        return this.b.isBlockPowered();
    }

    public boolean isBlockIndirectlyPowered() {
        return this.b.isBlockIndirectlyPowered();
    }

    public boolean isBlockFacePowered(BlockFace face) {
        return this.b.isBlockFacePowered(face);
    }

    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        return this.b.isBlockFaceIndirectlyPowered(face);
    }

    public int getBlockPower(BlockFace face) {
        return this.b.getBlockPower(face);
    }

    public int getBlockPower() {
        return this.b.getBlockPower();
    }

    public boolean isEmpty() {
        Material type = this.getType();
        assert (type != null);
        return BlockCompat.INSTANCE.isEmpty(type);
    }

    public boolean isLiquid() {
        Material type = this.getType();
        assert (type != null);
        return BlockCompat.INSTANCE.isLiquid(type);
    }

    public boolean isBuildable() {
        return this.b.isBuildable();
    }

    public boolean isBurnable() {
        return this.b.isBurnable();
    }

    public boolean isReplaceable() {
        return this.b.isReplaceable();
    }

    public boolean isSolid() {
        return this.b.isSolid();
    }

    public double getTemperature() {
        return this.b.getTemperature();
    }

    public double getHumidity() {
        return this.b.getHumidity();
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return this.b.getPistonMoveReaction();
    }

    public boolean breakNaturally() {
        if (this.newState != null) {
            return false;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

            @Override
            public void run() {
                DelayedChangeBlock.this.b.breakNaturally();
            }
        });
        return true;
    }

    public boolean breakNaturally(final @Nullable ItemStack tool) {
        if (this.newState != null) {
            return false;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

            @Override
            public void run() {
                DelayedChangeBlock.this.b.breakNaturally(tool);
            }
        });
        return true;
    }

    public boolean breakNaturally(final ItemStack tool, final boolean triggerEffect) {
        if (this.newState != null) {
            return false;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

            @Override
            public void run() {
                DelayedChangeBlock.this.b.breakNaturally(tool, triggerEffect);
            }
        });
        return true;
    }

    public boolean applyBoneMeal(BlockFace blockFace) {
        return this.b.applyBoneMeal(blockFace);
    }

    public Collection<ItemStack> getDrops() {
        return this.b.getDrops();
    }

    public Collection<ItemStack> getDrops(@Nullable ItemStack tool) {
        return this.b.getDrops(tool);
    }

    public Collection<ItemStack> getDrops(ItemStack tool, @Nullable Entity entity) {
        return this.b.getDrops(tool, entity);
    }

    @Nullable
    public Location getLocation(@Nullable Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX((double)this.getX());
            loc.setY((double)this.getY());
            loc.setZ((double)this.getZ());
            loc.setPitch(0.0f);
            loc.setYaw(0.0f);
        }
        return loc;
    }

    public void setType(final Material type, final boolean applyPhysics) {
        if (this.newState != null) {
            this.newState.setType(type);
        } else {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    DelayedChangeBlock.this.b.setType(type, applyPhysics);
                }
            });
        }
    }

    public BlockData getBlockData() {
        return this.b.getBlockData();
    }

    public void setBlockData(BlockData data) {
        this.setBlockData(data, true);
    }

    public void setBlockData(BlockData data, boolean applyPhysics) {
        if (this.newState != null) {
            this.newState.setBlockData(data);
        } else {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), () -> this.b.setBlockData(data, applyPhysics));
        }
    }

    @Nullable
    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        return this.b.rayTrace(start, direction, maxDistance, fluidCollisionMode);
    }

    public boolean isPassable() {
        return this.isPassable;
    }

    public BoundingBox getBoundingBox() {
        return this.b.getBoundingBox();
    }

    public BlockSoundGroup getSoundGroup() {
        return this.b.getSoundGroup();
    }

    public String getTranslationKey() {
        return this.b.getTranslationKey();
    }

    public float getDestroySpeed(ItemStack itemStack) {
        return this.b.getDestroySpeed(itemStack);
    }

    public boolean isPreferredTool(@NotNull ItemStack tool) {
        return this.b.isPreferredTool(tool);
    }

    public boolean isValidTool(@NotNull ItemStack itemStack) {
        return this.b.isValidTool(itemStack);
    }

    @NotNull
    public float getDestroySpeed(@NotNull ItemStack itemStack, boolean considerEnchants) {
        return this.b.getDestroySpeed(itemStack, considerEnchants);
    }
}

