/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.variables.SerializedVariable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;

public final class ListVariablePersistentDataType
implements PersistentDataType<byte[], Map<String, SerializedVariable.Value>> {
    private final int INT_LENGTH = 4;
    private final Charset SERIALIZED_CHARSET = StandardCharsets.UTF_8;

    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    public Class<Map<String, SerializedVariable.Value>> getComplexType() {
        return Map.class;
    }

    public byte[] toPrimitive(Map<String, SerializedVariable.Value> complex, PersistentDataAdapterContext context) {
        int bufferLength = 0;
        for (Map.Entry<String, SerializedVariable.Value> entry : complex.entrySet()) {
            bufferLength += 4 + entry.getKey().getBytes(this.SERIALIZED_CHARSET).length + 4 + entry.getValue().type.getBytes(this.SERIALIZED_CHARSET).length + 4 + entry.getValue().data.length;
        }
        ByteBuffer bb = ByteBuffer.allocate(bufferLength);
        for (Map.Entry<String, SerializedVariable.Value> entry : complex.entrySet()) {
            byte[] indexBytes = entry.getKey().getBytes(this.SERIALIZED_CHARSET);
            byte[] typeBytes = entry.getValue().type.getBytes(this.SERIALIZED_CHARSET);
            bb.putInt(indexBytes.length);
            bb.put(indexBytes);
            bb.putInt(typeBytes.length);
            bb.put(typeBytes);
            bb.putInt(entry.getValue().data.length);
            bb.put(entry.getValue().data);
        }
        return bb.array();
    }

    public Map<String, SerializedVariable.Value> fromPrimitive(byte[] primitive, PersistentDataAdapterContext context) {
        ByteBuffer bb = ByteBuffer.wrap(primitive);
        HashMap<String, SerializedVariable.Value> values = new HashMap<String, SerializedVariable.Value>();
        while (bb.hasRemaining()) {
            int indexLength = bb.getInt();
            byte[] indexBytes = new byte[indexLength];
            bb.get(indexBytes, 0, indexLength);
            String index = new String(indexBytes, this.SERIALIZED_CHARSET);
            int typeLength = bb.getInt();
            byte[] typeBytes = new byte[typeLength];
            bb.get(typeBytes, 0, typeLength);
            String type = new String(typeBytes, this.SERIALIZED_CHARSET);
            int dataLength = bb.getInt();
            byte[] dataBytes = new byte[dataLength];
            bb.get(dataBytes, 0, dataLength);
            values.put(index, new SerializedVariable.Value(type, dataBytes));
        }
        return values;
    }
}

