/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.ListVariablePersistentDataType;
import ch.njol.skript.util.SingleVariablePersistentDataType;
import ch.njol.skript.variables.SerializedVariable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.TileState;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class PersistentDataUtils {
    private static final PersistentDataType<byte[], SerializedVariable.Value> SINGLE_VARIABLE_TYPE = new SingleVariablePersistentDataType();
    private static final PersistentDataType<byte[], Map<String, SerializedVariable.Value>> LIST_VARIABLE_TYPE = new ListVariablePersistentDataType();

    private static Map<Object, PersistentDataHolder> getConvertedHolders(Object[] holders) {
        HashMap<Object, PersistentDataHolder> actualHolders = new HashMap<Object, PersistentDataHolder>();
        for (Object holder : holders) {
            if (holder instanceof PersistentDataHolder) {
                actualHolders.put(holder, (PersistentDataHolder)holder);
                continue;
            }
            if (holder instanceof ItemType) {
                actualHolders.put(holder, (PersistentDataHolder)((ItemType)holder).getItemMeta());
                continue;
            }
            if (!(holder instanceof Block) || !(((Block)holder).getState() instanceof TileState)) continue;
            actualHolders.put(holder, (PersistentDataHolder)((TileState)((Block)holder).getState()));
        }
        return actualHolders;
    }

    public static NamespacedKey getNamespacedKey(String name) {
        name = Base64.getEncoder().encodeToString(name.getBytes(StandardCharsets.UTF_8)).replace('=', '_').replace('+', '.');
        return new NamespacedKey((Plugin)Skript.getInstance(), name);
    }

    public static Object[] getSingle(String name, Object ... holders) {
        if (name.contains("::")) {
            return new Object[0];
        }
        Map<Object, PersistentDataHolder> actualHolders = PersistentDataUtils.getConvertedHolders(holders);
        if (actualHolders.isEmpty()) {
            return new Object[0];
        }
        name = "!!SINGLE!!" + name;
        NamespacedKey key = PersistentDataUtils.getNamespacedKey(name);
        ArrayList<Object> returnValues = new ArrayList<Object>();
        for (Map.Entry<Object, PersistentDataHolder> entry : actualHolders.entrySet()) {
            SerializedVariable.Value value;
            Object holder = entry.getKey();
            PersistentDataHolder actualHolder = entry.getValue();
            if (actualHolder.getPersistentDataContainer().has(key, SINGLE_VARIABLE_TYPE) && (value = (SerializedVariable.Value)actualHolder.getPersistentDataContainer().get(key, SINGLE_VARIABLE_TYPE)) != null) {
                returnValues.add(Classes.deserialize(value.type, value.data));
            }
            if (!(holder instanceof Metadatable)) continue;
            List values = ((Metadatable)holder).getMetadata(name);
            for (MetadataValue mv : values) {
                if (mv.getOwningPlugin() != Skript.getInstance()) continue;
                returnValues.add(mv.value());
            }
        }
        return returnValues.toArray();
    }

    public static void setSingle(String name, Object value, Object ... holders) {
        if (name.contains("::")) {
            return;
        }
        Map<Object, PersistentDataHolder> actualHolders = PersistentDataUtils.getConvertedHolders(holders);
        if (actualHolders.isEmpty()) {
            return;
        }
        name = "!!SINGLE!!" + name;
        SerializedVariable.Value serialized = Classes.serialize(value);
        if (serialized != null) {
            NamespacedKey key = PersistentDataUtils.getNamespacedKey(name);
            for (Map.Entry<Object, PersistentDataHolder> entry : actualHolders.entrySet()) {
                PersistentDataHolder actualHolder = entry.getValue();
                actualHolder.getPersistentDataContainer().set(key, SINGLE_VARIABLE_TYPE, (Object)serialized);
                Object holder = entry.getKey();
                if (holder instanceof ItemType) {
                    ((ItemType)holder).setItemMeta((ItemMeta)actualHolder);
                    continue;
                }
                if (!(actualHolder instanceof TileState)) continue;
                ((TileState)actualHolder).update();
            }
        } else {
            for (Object holder : actualHolders.keySet()) {
                if (!(holder instanceof Metadatable)) continue;
                ((Metadatable)holder).setMetadata(name, (MetadataValue)new FixedMetadataValue((Plugin)Skript.getInstance(), value));
            }
        }
    }

    public static void removeSingle(String name, Object ... holders) {
        if (name.contains("::")) {
            return;
        }
        Map<Object, PersistentDataHolder> actualHolders = PersistentDataUtils.getConvertedHolders(holders);
        if (actualHolders.isEmpty()) {
            return;
        }
        name = "!!SINGLE!!" + name;
        NamespacedKey key = PersistentDataUtils.getNamespacedKey(name);
        for (Map.Entry<Object, PersistentDataHolder> entry : actualHolders.entrySet()) {
            Object holder = entry.getKey();
            PersistentDataHolder actualHolder = entry.getValue();
            if (actualHolder.getPersistentDataContainer().has(key, SINGLE_VARIABLE_TYPE)) {
                actualHolder.getPersistentDataContainer().remove(key);
                if (holder instanceof ItemType) {
                    ((ItemType)holder).setItemMeta((ItemMeta)actualHolder);
                    continue;
                }
                if (!(actualHolder instanceof TileState)) continue;
                ((TileState)actualHolder).update();
                continue;
            }
            if (!(holder instanceof Metadatable)) continue;
            ((Metadatable)holder).removeMetadata(name, (Plugin)Skript.getInstance());
        }
    }

    public static Object[] getList(String name, Object ... holders) {
        if (!name.contains("::")) {
            return new Object[0];
        }
        String listName = name;
        if (!name.endsWith("*")) {
            listName = name.substring(0, name.lastIndexOf("::") + 2) + "*";
        }
        ArrayList<Object> returnValues = new ArrayList<Object>();
        for (Object holder : holders) {
            Map<String, Object> listVar = PersistentDataUtils.getListMap(listName, holder);
            if (listVar == null) continue;
            String index = name.substring(name.lastIndexOf("::") + "::".length());
            if (index.equals("*")) {
                returnValues.addAll(listVar.values());
                continue;
            }
            if (!listVar.containsKey(index)) continue;
            returnValues.add(listVar.get(index));
        }
        return returnValues.toArray();
    }

    public static void setList(String name, Object value, Object ... holders) {
        if (!name.contains("::")) {
            return;
        }
        Map<Object, PersistentDataHolder> actualHolders = PersistentDataUtils.getConvertedHolders(holders);
        if (actualHolders.isEmpty()) {
            return;
        }
        SerializedVariable.Value serialized = Classes.serialize(value);
        String keyName = "!!LIST!!" + name.substring(0, name.lastIndexOf("::"));
        if (serialized != null) {
            NamespacedKey key = PersistentDataUtils.getNamespacedKey(keyName);
            for (Map.Entry<Object, PersistentDataHolder> entry : actualHolders.entrySet()) {
                String index;
                PersistentDataHolder actualHolder = entry.getValue();
                HashMap<String, SerializedVariable.Value> values = (HashMap<String, SerializedVariable.Value>)actualHolder.getPersistentDataContainer().get(key, LIST_VARIABLE_TYPE);
                if (values == null) {
                    values = new HashMap<String, SerializedVariable.Value>();
                }
                if ((index = name.substring(name.lastIndexOf("::") + "::".length())).equals("*")) {
                    values.clear();
                    values.put("1", serialized);
                } else {
                    values.put(index, serialized);
                }
                actualHolder.getPersistentDataContainer().set(key, LIST_VARIABLE_TYPE, values);
                Object holder = entry.getKey();
                if (holder instanceof ItemType) {
                    ((ItemType)holder).setItemMeta((ItemMeta)actualHolder);
                    continue;
                }
                if (!(actualHolder instanceof TileState)) continue;
                ((TileState)actualHolder).update();
            }
        } else {
            for (Object holder : actualHolders.keySet()) {
                String index;
                if (!(holder instanceof Metadatable)) continue;
                Metadatable mHolder = (Metadatable)holder;
                Map<String, Object> mMap = null;
                for (MetadataValue mv : mHolder.getMetadata(keyName)) {
                    if (mv.getOwningPlugin() != Skript.getInstance()) continue;
                    mMap = (Map)mv.value();
                    break;
                }
                if (mMap == null) {
                    mMap = new HashMap();
                }
                if ((index = name.substring(name.lastIndexOf("::") + "::".length())).equals("*")) {
                    mMap.clear();
                    mMap.put("1", value);
                } else {
                    mMap.put(index, value);
                }
                mHolder.setMetadata(keyName, (MetadataValue)new FixedMetadataValue((Plugin)Skript.getInstance(), mMap));
            }
        }
    }

    public static void removeList(String name, Object ... holders) {
        if (!name.contains("::")) {
            return;
        }
        Map<Object, PersistentDataHolder> actualHolders = PersistentDataUtils.getConvertedHolders(holders);
        if (actualHolders.isEmpty()) {
            return;
        }
        String keyName = "!!LIST!!" + name.substring(0, name.lastIndexOf("::"));
        NamespacedKey key = PersistentDataUtils.getNamespacedKey(keyName);
        String index = name.substring(name.lastIndexOf("::") + "::".length());
        for (Map.Entry<Object, PersistentDataHolder> entry : actualHolders.entrySet()) {
            Object holder = entry.getKey();
            PersistentDataHolder actualHolder = entry.getValue();
            if (actualHolder.getPersistentDataContainer().has(key, LIST_VARIABLE_TYPE)) {
                if (index.equals("*")) {
                    actualHolder.getPersistentDataContainer().remove(key);
                } else {
                    Map values = (Map)actualHolder.getPersistentDataContainer().get(key, LIST_VARIABLE_TYPE);
                    if (values != null) {
                        values.remove(index);
                        if (values.isEmpty()) {
                            actualHolder.getPersistentDataContainer().remove(key);
                        } else {
                            actualHolder.getPersistentDataContainer().set(key, LIST_VARIABLE_TYPE, (Object)values);
                        }
                    }
                }
                if (holder instanceof ItemType) {
                    ((ItemType)holder).setItemMeta((ItemMeta)actualHolder);
                    continue;
                }
                if (!(actualHolder instanceof TileState)) continue;
                ((TileState)actualHolder).update();
                continue;
            }
            if (!(holder instanceof Metadatable)) continue;
            Metadatable mHolder = (Metadatable)holder;
            if (index.equals("*")) {
                mHolder.removeMetadata(keyName, (Plugin)Skript.getInstance());
                continue;
            }
            List mValues = mHolder.getMetadata(keyName);
            if (mValues.isEmpty()) continue;
            Map mMap = null;
            for (MetadataValue mv : mValues) {
                if (mv.getOwningPlugin() != Skript.getInstance()) continue;
                mMap = (Map)mv.value();
                break;
            }
            if (mMap == null) continue;
            mMap.remove(index);
            if (mMap.isEmpty()) {
                mHolder.removeMetadata(keyName, (Plugin)Skript.getInstance());
                continue;
            }
            mHolder.setMetadata(keyName, (MetadataValue)new FixedMetadataValue((Plugin)Skript.getInstance(), (Object)mMap));
        }
    }

    @Nullable
    public static Map<String, Object> getListMap(String name, Object holder) {
        if (!name.endsWith("*")) {
            return null;
        }
        PersistentDataHolder actualHolder = PersistentDataUtils.getConvertedHolders(new Object[]{holder}).get(holder);
        if (actualHolder == null) {
            return null;
        }
        String keyName = "!!LIST!!" + name.substring(0, name.lastIndexOf("::"));
        NamespacedKey key = PersistentDataUtils.getNamespacedKey(keyName);
        if (actualHolder.getPersistentDataContainer().has(key, LIST_VARIABLE_TYPE)) {
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)actualHolder.getPersistentDataContainer().get(key, LIST_VARIABLE_TYPE)).entrySet()) {
                returnMap.put((String)entry.getKey(), Classes.deserialize(((SerializedVariable.Value)entry.getValue()).type, ((SerializedVariable.Value)entry.getValue()).data));
            }
            return returnMap;
        }
        if (holder instanceof Metadatable) {
            Map mMap = null;
            for (MetadataValue mv : ((Metadatable)holder).getMetadata(keyName)) {
                if (mv.getOwningPlugin() != Skript.getInstance()) continue;
                mMap = (Map)mv.value();
                break;
            }
            return mMap;
        }
        return null;
    }

    public static void setListMap(String name, Map<String, Object> varMap, Object holder) {
        if (!name.endsWith("*")) {
            return;
        }
        if (varMap.isEmpty()) {
            PersistentDataUtils.removeList(name, holder);
            return;
        }
        PersistentDataHolder actualHolder = PersistentDataUtils.getConvertedHolders(new Object[]{holder}).get(holder);
        if (actualHolder == null) {
            return;
        }
        String keyName = "!!LIST!!" + name.substring(0, name.lastIndexOf("::"));
        NamespacedKey key = PersistentDataUtils.getNamespacedKey(keyName);
        if (actualHolder.getPersistentDataContainer().has(key, LIST_VARIABLE_TYPE)) {
            HashMap<String, SerializedVariable.Value> serializedMap = new HashMap<String, SerializedVariable.Value>();
            for (Map.Entry<String, Object> entry : varMap.entrySet()) {
                serializedMap.put(entry.getKey(), Classes.serialize(entry.getValue()));
            }
            actualHolder.getPersistentDataContainer().set(key, LIST_VARIABLE_TYPE, serializedMap);
        } else if (holder instanceof Metadatable) {
            ((Metadatable)holder).setMetadata(keyName, (MetadataValue)new FixedMetadataValue((Plugin)Skript.getInstance(), varMap));
        }
        if (holder instanceof ItemType) {
            ((ItemType)holder).setItemMeta((ItemMeta)actualHolder);
        } else if (actualHolder instanceof TileState) {
            ((TileState)actualHolder).update();
        }
    }

    @Nullable
    public static Set<String> getListIndexes(String name, Object holder) {
        if (!name.endsWith("*")) {
            return null;
        }
        PersistentDataHolder actualHolder = PersistentDataUtils.getConvertedHolders(new Object[]{holder}).get(holder);
        if (actualHolder == null) {
            return null;
        }
        String keyName = "!!LIST!!" + name.substring(0, name.lastIndexOf("::"));
        NamespacedKey key = PersistentDataUtils.getNamespacedKey(keyName);
        if (actualHolder.getPersistentDataContainer().has(key, LIST_VARIABLE_TYPE)) {
            return ((Map)actualHolder.getPersistentDataContainer().get(key, LIST_VARIABLE_TYPE)).keySet();
        }
        if (holder instanceof Metadatable) {
            for (MetadataValue mv : ((Metadatable)holder).getMetadata(keyName)) {
                if (mv.getOwningPlugin() != Skript.getInstance()) continue;
                return ((Map)mv.value()).keySet();
            }
        }
        return null;
    }

    public static boolean has(String name, Object ... holders) {
        Map<Object, PersistentDataHolder> actualHolders = PersistentDataUtils.getConvertedHolders(holders);
        if (actualHolders.isEmpty()) {
            return false;
        }
        boolean isList = name.contains("::");
        String keyName = isList ? "!!LIST!!" + name.substring(0, name.lastIndexOf("::")) : "!!SINGLE!!" + name;
        NamespacedKey key = PersistentDataUtils.getNamespacedKey(keyName);
        if (isList) {
            for (Map.Entry<Object, PersistentDataHolder> entry : actualHolders.entrySet()) {
                Object holder = entry.getKey();
                PersistentDataHolder actualHolder = entry.getValue();
                String index = name.substring(name.lastIndexOf("::") + "::".length());
                if (actualHolder.getPersistentDataContainer().has(key, LIST_VARIABLE_TYPE)) {
                    if (index.equals("*") || ((Map)actualHolder.getPersistentDataContainer().get(key, LIST_VARIABLE_TYPE)).containsKey(index)) continue;
                    return false;
                }
                if (!(holder instanceof Metadatable)) continue;
                Metadatable mHolder = (Metadatable)holder;
                if (!mHolder.hasMetadata(keyName)) {
                    return false;
                }
                for (MetadataValue mv : mHolder.getMetadata(keyName)) {
                    if (mv.getOwningPlugin() != Skript.getInstance() || ((Map)mv.value()).containsKey(index)) continue;
                    return false;
                }
            }
        } else {
            for (Map.Entry<Object, PersistentDataHolder> entry : actualHolders.entrySet()) {
                if (entry.getValue().getPersistentDataContainer().has(key, SINGLE_VARIABLE_TYPE) || ((Metadatable)entry.getKey()).hasMetadata(keyName)) continue;
                return false;
            }
        }
        return true;
    }
}

