/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.variables.SerializedVariable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;

public final class SingleVariablePersistentDataType
implements PersistentDataType<byte[], SerializedVariable.Value> {
    private final int INT_LENGTH = 4;
    private final Charset SERIALIZED_CHARSET = StandardCharsets.UTF_8;

    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    public Class<SerializedVariable.Value> getComplexType() {
        return SerializedVariable.Value.class;
    }

    public byte[] toPrimitive(SerializedVariable.Value complex, PersistentDataAdapterContext context) {
        byte[] type = complex.type.getBytes(this.SERIALIZED_CHARSET);
        ByteBuffer bb = ByteBuffer.allocate(4 + type.length + complex.data.length);
        bb.putInt(type.length);
        bb.put(type);
        bb.put(complex.data);
        return bb.array();
    }

    public SerializedVariable.Value fromPrimitive(byte[] primitive, PersistentDataAdapterContext context) {
        ByteBuffer bb = ByteBuffer.wrap(primitive);
        int typeLength = bb.getInt();
        byte[] typeBytes = new byte[typeLength];
        bb.get(typeBytes, 0, typeLength);
        String type = new String(typeBytes, this.SERIALIZED_CHARSET);
        byte[] data = new byte[bb.remaining()];
        bb.get(data);
        return new SerializedVariable.Value(type, data);
    }
}

