/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.util.Utils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public class Version
implements Serializable,
Comparable<Version> {
    private static final long serialVersionUID = 8687040355286333293L;
    private final int[] version = new int[3];
    @Nullable
    private final String postfix;
    public static final Pattern versionPattern = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.(\\d+))?\\s*(.*)");

    public Version(int ... version) {
        if (version.length < 1 || version.length > 3) {
            throw new IllegalArgumentException("Versions must have a minimum of 2 and a maximum of 3 numbers (" + version.length + " numbers given)");
        }
        for (int i = 0; i < version.length; ++i) {
            this.version[i] = version[i];
        }
        this.postfix = null;
    }

    public Version(int major, int minor, @Nullable String postfix) {
        this.version[0] = major;
        this.version[1] = minor;
        this.postfix = postfix == null || postfix.isEmpty() ? null : postfix;
    }

    public Version(String version) {
        Matcher m = versionPattern.matcher(version.trim());
        if (!m.matches()) {
            throw new IllegalArgumentException("'" + version + "' is not a valid version string");
        }
        for (int i = 0; i < 3; ++i) {
            if (m.group(i + 1) == null) continue;
            this.version[i] = Utils.parseInt("" + m.group(i + 1));
        }
        this.postfix = m.group(m.groupCount()).isEmpty() ? null : m.group(m.groupCount());
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)obj) == 0;
    }

    public int hashCode() {
        String pf = this.postfix;
        return Arrays.hashCode(this.version) * 31 + (pf == null ? 0 : pf.hashCode());
    }

    @Override
    public int compareTo(@Nullable Version other) {
        if (other == null) {
            return 1;
        }
        for (int i = 0; i < this.version.length; ++i) {
            if (this.version[i] > other.version[i]) {
                return 1;
            }
            if (this.version[i] >= other.version[i]) continue;
            return -1;
        }
        String pf = this.postfix;
        if (pf == null) {
            return other.postfix == null ? 0 : 1;
        }
        return other.postfix == null ? -1 : pf.compareTo(other.postfix);
    }

    @Override
    public int compareTo(int ... other) {
        assert (other.length >= 2 && other.length <= 3);
        for (int i = 0; i < this.version.length; ++i) {
            if (this.version[i] > (i >= other.length ? 0 : other[i])) {
                return 1;
            }
            if (this.version[i] >= (i >= other.length ? 0 : other[i])) continue;
            return -1;
        }
        return 0;
    }

    public boolean isSmallerThan(Version other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLargerThan(Version other) {
        return this.compareTo(other) > 0;
    }

    public boolean isStable() {
        return this.postfix == null;
    }

    public int getMajor() {
        return this.version[0];
    }

    public int getMinor() {
        return this.version[1];
    }

    public int getRevision() {
        return this.version.length == 2 ? 0 : this.version[2];
    }

    public String toString() {
        String pf = this.postfix;
        return this.version[0] + "." + this.version[1] + (this.version[2] == 0 ? "" : "." + this.version[2]) + (pf == null ? "" : (pf.startsWith("-") ? pf : " " + pf));
    }

    public static int compare(String v1, String v2) {
        return new Version(v1).compareTo(new Version(v2));
    }
}

