/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util.visual;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.ColorRGB;
import ch.njol.skript.util.Direction;
import ch.njol.skript.util.SkriptColor;
import ch.njol.skript.util.visual.ParticleOption;
import ch.njol.skript.util.visual.VisualEffect;
import ch.njol.skript.util.visual.VisualEffectType;
import ch.njol.skript.variables.Variables;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.iterator.SingleItemIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.eclipse.jdt.annotation.Nullable;

public class VisualEffects {
    private static final boolean NEW_EFFECT_DATA = Skript.classExists("org.bukkit.block.data.BlockData");
    private static final boolean HAS_REDSTONE_DATA = Skript.classExists("org.bukkit.Particle$DustOptions");
    private static final Map<String, Consumer<VisualEffectType>> effectTypeModifiers = new HashMap<String, Consumer<VisualEffectType>>();
    private static SyntaxElementInfo<VisualEffect> elementInfo;
    private static VisualEffectType[] visualEffectTypes;

    @Nullable
    public static VisualEffect parse(String s) {
        if (elementInfo == null) {
            return null;
        }
        return SkriptParser.parseStatic(Noun.stripIndefiniteArticle(s), new SingleItemIterator<SyntaxElementInfo<VisualEffect>>(elementInfo), null);
    }

    public static VisualEffectType get(int i) {
        return visualEffectTypes[i];
    }

    public static String getAllNames() {
        ArrayList<Noun> names = new ArrayList<Noun>();
        for (VisualEffectType visualEffectType : visualEffectTypes) {
            names.add(visualEffectType.getName());
        }
        return StringUtils.join(names, ", ");
    }

    private static void generateTypes() {
        ArrayList types = new ArrayList();
        Stream.of(Effect.class, EntityEffect.class, Particle.class).map(Class::getEnumConstants).flatMap(Arrays::stream).map(VisualEffectType::of).filter(Objects::nonNull).forEach(types::add);
        for (VisualEffectType type : types) {
            String id = type.getId();
            if (!effectTypeModifiers.containsKey(id)) continue;
            effectTypeModifiers.get(id).accept(type);
        }
        visualEffectTypes = types.toArray(new VisualEffectType[0]);
        String[] patterns = new String[visualEffectTypes.length];
        for (int i = 0; i < visualEffectTypes.length; ++i) {
            patterns[i] = visualEffectTypes[i].getPattern();
        }
        elementInfo = new SyntaxElementInfo<VisualEffect>(patterns, VisualEffect.class, VisualEffect.class.getName());
    }

    private static void registerColorable(String id) {
        effectTypeModifiers.put(id, VisualEffectType::setColorable);
    }

    private static void registerDataSupplier(String id, BiFunction<Object, Location, Object> dataSupplier) {
        Consumer<VisualEffectType> consumer = type -> type.withData(dataSupplier);
        if (effectTypeModifiers.containsKey(id)) {
            consumer = effectTypeModifiers.get(id).andThen(consumer);
        }
        effectTypeModifiers.put(id, consumer);
    }

    static {
        Variables.yggdrasil.registerSingleClass(VisualEffectType.class, "VisualEffect.NewType");
        Variables.yggdrasil.registerSingleClass(Effect.class, "Bukkit_Effect");
        Variables.yggdrasil.registerSingleClass(EntityEffect.class, "Bukkit_EntityEffect");
        Language.addListener(() -> {
            if (visualEffectTypes != null) {
                return;
            }
            VisualEffects.registerColorable("Particle.SPELL_MOB");
            VisualEffects.registerColorable("Particle.SPELL_MOB_AMBIENT");
            VisualEffects.registerColorable("Particle.REDSTONE");
            VisualEffects.registerColorable("Particle.NOTE");
            VisualEffects.registerDataSupplier("Effect.POTION_BREAK", (raw, location) -> new PotionEffect(raw == null ? PotionEffectType.SPEED : (PotionEffectType)raw, 1, 0));
            VisualEffects.registerDataSupplier("Effect.SMOKE", (raw, location) -> {
                if (raw == null) {
                    return BlockFace.SELF;
                }
                return Direction.getFacing(((Direction)raw).getDirection((Location)location), false);
            });
            SkriptColor defaultColor = SkriptColor.LIGHT_RED;
            VisualEffects.registerDataSupplier("Particle.SPELL_MOB", (raw, location) -> {
                Color color = raw == null ? defaultColor : (Color)raw;
                return new ParticleOption(color, 1.0f);
            });
            VisualEffects.registerDataSupplier("Particle.SPELL_MOB_AMBIENT", (raw, location) -> {
                Color color = raw == null ? defaultColor : (Color)raw;
                return new ParticleOption(color, 1.0f);
            });
            VisualEffects.registerDataSupplier("Particle.REDSTONE", (raw, location) -> {
                Color color = raw == null ? defaultColor : (Color)raw;
                ParticleOption particleOption = new ParticleOption(color, 1.0f);
                if (HAS_REDSTONE_DATA && Particle.REDSTONE.getDataType() == Particle.DustOptions.class) {
                    return new Particle.DustOptions(particleOption.getBukkitColor(), particleOption.size);
                }
                return particleOption;
            });
            VisualEffects.registerDataSupplier("Particle.NOTE", (raw, location) -> {
                int colorValue = (int)(((Number)raw).floatValue() * 255.0f);
                ColorRGB color = new ColorRGB(colorValue, 0, 0);
                return new ParticleOption(color, 1.0f);
            });
            VisualEffects.registerDataSupplier("Particle.ITEM_CRACK", (raw, location) -> {
                ItemStack itemStack = Aliases.javaItemType("iron sword").getRandom();
                if (raw instanceof ItemType) {
                    ItemStack rand = ((ItemType)raw).getRandom();
                    if (rand != null) {
                        itemStack = rand;
                    }
                } else if (raw != null) {
                    return raw;
                }
                assert (itemStack != null);
                if (Particle.ITEM_CRACK.getDataType() == Material.class) {
                    return itemStack.getType();
                }
                return itemStack;
            });
            BiFunction<Object, Location, Object> crackDustBiFunction = (raw, location) -> {
                if (raw == null) {
                    return Material.STONE.getData();
                }
                if (raw instanceof ItemType) {
                    ItemStack rand = ((ItemType)raw).getRandom();
                    if (NEW_EFFECT_DATA) {
                        return Bukkit.createBlockData((Material)(rand != null ? rand.getType() : Material.STONE));
                    }
                    if (rand == null) {
                        return Material.STONE.getData();
                    }
                    MaterialData type = rand.getData();
                    assert (type != null);
                    return type;
                }
                return raw;
            };
            VisualEffects.registerDataSupplier("Particle.BLOCK_CRACK", crackDustBiFunction);
            VisualEffects.registerDataSupplier("Particle.BLOCK_DUST", crackDustBiFunction);
            VisualEffects.registerDataSupplier("Particle.FALLING_DUST", crackDustBiFunction);
            VisualEffects.generateTypes();
        });
    }
}

