/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.yggdrasil.util;

import ch.njol.yggdrasil.FieldHandler;
import ch.njol.yggdrasil.Fields;
import ch.njol.yggdrasil.YggdrasilException;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JREFieldHandler
implements FieldHandler {
    @Override
    public boolean excessiveField(Object o, Fields.FieldContext field) {
        return false;
    }

    @Override
    public boolean missingField(Object o, Field field) throws StreamCorruptedException {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean incompatibleField(Object o, Field f, Fields.FieldContext field) throws StreamCorruptedException {
        List<Object> value = field.getObject();
        if (value instanceof Object[]) {
            value = Arrays.asList(value);
        }
        if (value instanceof Collection) {
            Collection v = value;
            try {
                if (Collection.class.isAssignableFrom(f.getType())) {
                    Collection c = (Collection)f.get(o);
                    if (c == null) return false;
                    c.clear();
                    c.addAll(v);
                    return true;
                }
                if (!Object[].class.isAssignableFrom(f.getType())) return false;
                Object[] array = (Object[])f.get(o);
                if (array != null) {
                    if (array.length < v.size()) {
                        return false;
                    }
                    Class<?> ct = array.getClass().getComponentType();
                    for (Object x : v) {
                        if (ct.isInstance(x)) continue;
                        return false;
                    }
                } else {
                    array = (Object[])Array.newInstance(f.getType().getComponentType(), v.size());
                    f.set(o, array);
                }
                int l = array.length;
                int i = 0;
                for (Object x : v) {
                    array[i++] = x;
                }
                while (i < l) {
                    array[i++] = null;
                }
                return false;
            }
            catch (IllegalArgumentException e) {
                throw new YggdrasilException(e);
            }
            catch (IllegalAccessException e) {
                throw new YggdrasilException(e);
            }
            catch (UnsupportedOperationException e) {
                throw new YggdrasilException(e);
            }
            catch (ClassCastException e) {
                throw new YggdrasilException(e);
            }
            catch (NullPointerException e) {
                throw new YggdrasilException(e);
            }
            catch (IllegalStateException e) {
                throw new YggdrasilException(e);
            }
        } else {
            if (!(value instanceof Map)) return false;
            if (!Map.class.isAssignableFrom(f.getType())) {
                return false;
            }
            try {
                Map m = (Map)f.get(o);
                if (m == null) return false;
                m.clear();
                m.putAll((Map)((Object)value));
                return true;
            }
            catch (IllegalArgumentException e) {
                throw new YggdrasilException(e);
            }
            catch (IllegalAccessException e) {
                throw new YggdrasilException(e);
            }
            catch (UnsupportedOperationException e) {
                throw new YggdrasilException(e);
            }
            catch (ClassCastException e) {
                throw new YggdrasilException(e);
            }
            catch (NullPointerException e) {
                throw new YggdrasilException(e);
            }
        }
    }
}

